/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import javax.swing.JPanel;

public class Twiddler
extends JPanel {
    public int numControls;
    public ConfigSet config;

    public Twiddler() {
        this(System.in, System.out);
    }

    public Twiddler(InputStream inputStream, PrintStream printStream) {
        this.config = new ConfigSet(inputStream, printStream);
        this.numControls = 0;
        this.setLayout(new GridLayout(1, 2));
        this.config.inputDefinition(this);
        if (this.numControls == 0) {
            this.add(new Label("No controls added!"));
        }
        this.setLayout(new GridLayout(this.numControls, 2));
    }

    public static void main(String[] stringArray) throws IOException {
        Frame frame = new Frame("Twiddler");
        frame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                System.exit(0);
            }
        });
        String string = Long.toString(Thread.currentThread().getId());
        String string2 = ".control-" + string + ".in";
        String string3 = ".control-" + string + ".out";
        Process process = Runtime.getRuntime().exec("mkfifo " + string2 + " " + string3);
        int n = -1;
        while (n < 0) {
            try {
                n = process.waitFor();
            }
            catch (InterruptedException interruptedException) {}
        }
        if (n != 0) {
            System.err.println("Error: unable to create control fifos");
            System.exit(n);
        }
        System.err.print("Waiting to connect to " + string2 + "... ");
        System.err.flush();
        PrintStream printStream = new PrintStream(new FileOutputStream(string2));
        System.err.println("connected");
        System.err.print("Waiting to connect to " + string3 + "... ");
        System.err.flush();
        FileInputStream fileInputStream = new FileInputStream(string3);
        System.err.println("done");
        Twiddler twiddler = new Twiddler(fileInputStream, printStream);
        frame.add("Center", twiddler);
        frame.pack();
        frame.setVisible(true);
        twiddler.config.monitorInputForever();
    }
}

